$(async function () {

    GetUser();
    CargarTabla([]);
    CargarContrato();
    CargarRegistros();

    $("#btnNuevo").click(function (e) {
        Nuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });
    
});


var api = "/local/documentos";
var registros = [];


function GetUser() {
    let user = sessionStorage.getItem("usuario");
    if (user != null) $("#spUsuario").text("@" + user);
}


function getParameterByName(name) {
    name = name.replace(/[\[\]]/g, "\\$&");
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
}


async function CargarContrato() {

    var id = getParameterByName("id");
    var result = getData("/local/contratos/" + id);
    console.log(result);

    $("#lblProyecto").text("Proyecto: " + 1 );

}


async function CargarRegistros() {

    try {
        $("#divLoading").show();
        var result = await getData(api);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        registros = result;
        CargarTabla(registros);
    }
    catch (err) {
        MensajeError(err.message);
    }
}



function Nuevo() {

    $("#hfId").val("");
    $("#txtNombre").val("");

    $('#spTitulo').html('Nuevo Estatus');
    $('#procesoModal').modal('show');
}


async function Almacenar() {

    var result;
    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    var dto = { nombre: nombre };

    if (id == "") {
        $("#divLoading").show();
        result = await postData(api, dto);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        MensajeExitoso("registro almacenado");
    }
    else {
        $("#divLoading").show();
        result = await putData(api + "/" + id, dto);
        console.log(result);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        MensajeExitoso("registro actualizado");
    }

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoModal').modal('hide');
}


function Editar(id) {

    var index = registros.findIndex(a => a.id_estatus == id);
    var dto = registros[index];

    $("#hfId").val(id);
    $("#txtNombre").val(dto.nombre);

    $('#spTitulo').html('Editar Estatus');
    $('#procesoModal').modal('show');
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_estatus" },
            { mData: "nombre" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [2],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + full.id_estatus + ');" class="btn btn-ligth btn-sm">Editar</span></a>';
                }
            },
            {
                "aTargets": [3],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + full.id_estatus + ');" class="btn btn-ligth btn-sm">Borrar</span></a>';
                }
            }
        ],
        order: [[0, 'asc']], // Esto establecerá el orden inicial en la primera columna (cambiar el índice según sea necesario) en orden descendente
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}