$(function () {

    GetUser();
    CargarTabla([]);
    CargarRegistros();

    $("#btnNuevo").on("click", function (e) {
        Nuevo();
    });

    $("#btnAlmacenar").on("click", function (e) {
        Almacenar();
    });

    $("#btnEliminar").on("click", function (e) {
        Eliminar();
    });

    $("#btnPassword").on("click", function (e) {
        Password();
        return true;
    });

});

var api = "/local/contratos";
var registros = [];

function GetUser() {
    let user = sessionStorage.getItem("usuario");
    if (user != null) $("#spUsuario").text("@" + user);
}


async function CargarRegistros() {

    try {
        $("#divLoading").show();
        var result = await getData(api);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        registros = result;
        CargarTabla(registros);
    }
    catch (err) {
        MensajeError(err.message);
    }
}


function Nuevo() {

    $("#hfId").val("");
    $("#txtCodigo").val("");
    $("#txtReferencia").val("");
    $("#txtEmpresa").val("");
    $("#txtResponsble").val("");
    $("#txtPuesto").val("");
    $("#txtEmail").val("");
    $("#txtDireccion").val("");
    $("#txtTelefono").val("");


    $('#spTitulo').text('Nuevo Contrato');
    $('#procesoModal').modal('show');
}


async function Almacenar() {

    var id = $("#hfId").val();

    var codigo = id ? $("#txtCodigo").val().trim() : "";
    var referencia = $("#txtReferencia").val().trim();
    var meses = $("#txtMeses").val().trim();
    var costo = $("#txtCosto").val().trim();
    var empresa = $("#txtEmpresa").val().trim();
    var responsable = $("#txtResponsble").val().trim();
    var puesto = $("#txtPuesto").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var telefono = $("#txtTelefono").val().trim();


    if (referencia == "") {
        MensajeError("Ingrese referencia");
        return;
    }

    if (meses == "") {
        MensajeError("Ingrese meses");
        return;
    }

    if (!isInteger(meses)) {
        MensajeError("Ingrese valor entero en meses");
        return;
    }

    if (costo == "") {
        MensajeError("Ingrese costo");
        return;
    }

    if (!isDecimal(costo)) {
        MensajeError("Ingrese valor decimal en costo");
        return;
    }

    if (empresa == "") {
        MensajeError("Ingrese empresa");
        return;
    }

    if (responsable == "") {
        MensajeError("Ingrese responsable");
        return;
    }

    if (puesto == "") {
        MensajeError("Ingrese puesto");
        return;
    }

    if (email == "") {
        MensajeError("Ingrese email");
        return;
    }

    if (!isValidEmail(email)) {
        MensajeError("Ingrese email válido");
        return;
    }

    if (direccion == "") {
        MensajeError("Ingrese direccion");
        return;
    }

    if (telefono == "") {
        MensajeError("Ingrese telefono");
        return;
    }

    var dto = { codigo, referencia, meses, costo, empresa, responsable, puesto, email, direccion, telefono };

    if (id == "") {

        $("#divLoading").show();
        let result = await postData(api, dto);
        console.log(result);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        MensajeExitoso("registro almacenado");
    }
    else {

        $("#divLoading").show();
        let result = await putData(api + "/" + id, dto);
        $("#divLoading").hide();

        if (result.error) {
            MensajeError(result.error);
            return;
        }

        MensajeExitoso("registro actualizado");
    }

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoModal').modal('hide');
}


function Editar(id) {

    var index = registros.findIndex(a => a.id_contrato == id);
    var dto = registros[index];

    $("#hfId").val(id);

    $("#txtCodigo").val(dto.codigo);
    $("#txtReferencia").val(dto.referencia);
    $("#txtMeses").val(dto.meses);
    $("#txtCosto").val(dto.costo);
    $("#txtEmpresa").val(dto.empresa);
    $("#txtResponsble").val(dto.responsable);
    $("#txtPuesto").val(dto.puesto);
    $("#txtEmail").val(dto.email);
    $("#txtDireccion").val(dto.direccion);
    $("#txtTelefono").val(dto.telefono);


    $('#spTitulo').html('Editar Contrato');
    $('#procesoModal').modal('show');
}


function Borrar(id) {

    $("#hfId").val(id);
    var index = registros.findIndex(a => a.id_contrato == id);
    var dto = registros[index];

    $('#spTituloDe').html('Eliminar Contrato: ' + dto.referencia);
    $("#spObservacionDe").html("¿Esta seguro de eliminar este registro?")
    $('#procesoEliminar').modal('show');
}


async function Eliminar() {
    var id = $("#hfId").val();
    $("#divLoading").show();
    var result = await deleteData(api + "/" + id);
    $("#divLoading").hide();

    if (result.error) {
        MensajeError(result.error);
        return;
    }

    $("#hfId").val("");
    CargarRegistros();

    $('#procesoEliminar').modal('hide');
    MensajeExitoso("registro eliminado");
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_contrato" },
            { mData: "codigo" },
            { mData: "empresa" },
            { mData: "responsable" },
            { mData: "createdAt" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [5],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + full.id_contrato + ');" class="btn btn-ligth btn-sm">Editar</span></a>';
                }
            },
            {
                "aTargets": [6],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Estatus(' + full.id_contrato + ');" class="btn btn-ligth btn-sm">Estatus</span></a>';
                }
            },
            {
                "aTargets": [7],
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Documentos(' + full.id_contrato + ');" class="btn btn-ligth btn-sm">Documentos</span></a>';
                }
            }
        ],
        order: [[0, 'desc']], // Esto establecerá el orden inicial en la primera columna (cambiar el índice según sea necesario) en orden descendente
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}


function Estatus(id){
    window.location.href = "/transaction?id=" + id;
}


function Documentos(id){
    window.location.href = "/upload?id=" + id;
}


