const dbConfig = require("../config/db.config.js");

const Sequelize = require("sequelize");
const sequelize = new Sequelize(dbConfig.DB, dbConfig.USER, dbConfig.PASSWORD, {
  host: dbConfig.HOST,
  dialect: dbConfig.DIALECT,
  operatorsAliases: false, // evita inyecciones SQL
  timezone: '-06:00', 
  pool: {
    max: dbConfig.pool.max,
    min: dbConfig.pool.min,
    acquire: dbConfig.pool.acquire,
    idle: dbConfig.pool.idle
  }
});

const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

//modelos
db.usuario = require('./usuario.js')(sequelize, Sequelize);
db.contrato = require('./contrato.js')(sequelize, Sequelize);
db.estatus = require('./estatus.js')(sequelize, Sequelize);
db.transaccion = require('./transaccion.js')(sequelize, Sequelize);
db.documento = require('./documento.js')(sequelize, Sequelize);



// Configurar las asociaciones
Object.keys(db).forEach((modelName) => {
  if (db[modelName].associate) {
      db[modelName].associate(db);
  }
});

module.exports = db;