const dayjs = require('dayjs');

module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("contrato", {
        id_contrato: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        meses: { type: Sequelize.INTEGER, allowNull: false },
        costo: { type: Sequelize.FLOAT, allowNull: false },
        codigo: { type: Sequelize.STRING, max: 6, allowNull: false },
        referencia: { type: Sequelize.STRING, max: 100, allowNull: false },
        empresa: { type: Sequelize.STRING, max: 100, allowNull: false },
        responsable: { type: Sequelize.STRING, max: 100, allowNull: false },
        puesto: { type: Sequelize.STRING, max: 100, allowNull: true },
        email: { type: Sequelize.STRING, max: 100, allowNull: false },
        direccion: { type: Sequelize.STRING, max: 100, allowNull: true },
        telefono: { type: Sequelize.STRING, max: 100, allowNull: true },
        id: { type: Sequelize.STRING, max: 100, allowNull: true },
        ciudad: { type: Sequelize.STRING, max: 100, allowNull: true },
        region: { type: Sequelize.STRING, max: 100, allowNull: true },
        estado: { type: Sequelize.STRING, max: 100, allowNull: true },
        pais: { type: Sequelize.STRING, max: 100, allowNull: true },
        ip: { type: Sequelize.STRING, max: 100, allowNull: true },
        createdAt: {
            type: Sequelize.DATE, allowNull: false, default: new Date(),
            get() {
                const fecha = this.getDataValue('createdAt');
                return dayjs(fecha).format('YYYY-MM-DD HH:mm');
            }
        },
        updatedAt: { type: Sequelize.DATE, allowNull: false, default: new Date() },
        inicio: {
            type: Sequelize.DATE, allowNull: true, default: null,
            get() {
                const fecha = this.getDataValue('inicio');
                return fecha ? dayjs(fecha).format('YYYY-MM-DD HH:mm') : null;
            }
        },
        fin: {
            type: Sequelize.DATE, allowNull: true, default: null,
            get() {
                const fecha = this.getDataValue('fin');
                return fecha ? dayjs(fecha).format('YYYY-MM-DD HH:mm') : null;
            }
        },
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'contrato'
    });

    return modelo;
};