const db = require("../models");
const model = db.usuario;
const Op = db.Sequelize.Op;


exports.get = async (req, res) => {
    try {
        const id = req.params.id;
        var condition = id ? { id_usuario: id } : null;

        const data = await model.findAll({ where: condition, order: [['usuario', 'ASC']], });
        return res.status(200).send(data);
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
}


exports.post = async (req, res) => {
    try {

        if (!req.body.nombre) return res.status(400).send({ error: "ingrese nombre" });
        if (!req.body.usuario) return res.status(400).send({ error: "ingrese usuario" });
        if (!req.body.clave) return res.status(400).send({ error: "ingrese clave" });
        if (!req.body.tipo) return res.status(400).send({ error: "ingrese tipo" });

        var usuario = req.body.usuario;
        var condition = usuario ? { usuario: { [Op.like]: `%${usuario}%` } } : null;

        var registros = await model.findAll({ where: condition })

        if (registros.length > 0) return res.status(400).send({ error: "ya existe registro con ese usuario" });

        const hashed = await GenerarHash(req.body.clave);

        await model.create({
            nombre: req.body.nombre.toUpperCase(),
            usuario: req.body.usuario.toUpperCase(),
            clave: hashed,
            tipo: req.body.tipo.toUpperCase()
        });

        return res.status(200).send({ mensaje: "Registro almacenado exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.put = async (req, res) => {
    try {
        if (!req.body.nombre) return res.status(400).send({ error: "ingrese nombre" });
        if (!req.body.usuario) return res.status(400).send({ error: "ingrese usuario" });
        if (!req.body.tipo) return res.status(400).send({ error: "ingrese tipo" });
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });

        var id = req.params.id;
        var nombre = req.body.nombre.toUpperCase();
        var usuario = req.body.usuario.toUpperCase();
        var tipo = req.body.tipo.toUpperCase();
        var condition = nombre ? { usuario: { [Op.like]: `%${usuario}%` }, id_usuario: { [Op.not]: id } } : null;

        var registros = await model.findAll({ where: condition });

        if (registros > 0) return res.status(400).send({ error: "ya existe registro con ese nombre" });

        await model.update(
            {
                usuario: usuario,
                nombre: nombre,
                tipo: tipo,
            },
            {
                where: { id_usuario: id }
            }
        );

        return res.status(200).send({ mensaje: "Registro actualizado exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.delete = async (req, res) => {
    try {
        if (!req.params.id) return res.status(400).send({ error: "ingrese id" });

        let id = req.params.id;

        await model.destroy({
            where: { id_usuario: id }
        });

        return res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.login = async (req, res) => {
    try {
        if (!req.body.usuario) return res.status(400).send({ error: "ingrese usuario" });
        if (!req.body.clave) return res.status(400).send({ error: "ingrese clave" });

        var model = db.usuario;
        var usuario = req.body.usuario.toUpperCase();
        var condition = usuario ? { usuario: { [Op.like]: `%${usuario}%` } } : null;
        var user = await model.findOne({ where: condition });

        if (!user) return res.status(404).send({ error: "usuario no existe" });

        var hash = await GenerarHash(req.body.clave)
        var salida = await Compare(hash, user.clave);

        if (!salida) return res.status(400).send({ error: "clave incorrecta" });

        req.session.loggedIn = true;
        req.session.usuario = req.body.usuario.toUpperCase();
        req.session.id = user.id;
        req.session.id_usuario = user.id;

        return res.status(200).send({ mensaje: "usuario logueado" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.password = async (req, res) => {
    try {
        if (!req.body.clave) return res.send({ error: "ingrese clave" });
        if (!req.params.id) return res.send({ error: "ingrese id" });

        var id = req.params.id;
        const hashed = await GenerarHash(req.body.clave);

        await model.update(
            {
                clave: hashed
            },
            {
                where: { id_usuario: id }
            }
        );

        return res.status(200).send({ mensaje: "Registro actualizado exitosamente", error: "" });
    }
    catch (err) {
        return res.status(500).send({ error: "error: " + err.message })
    }
};


exports.current = (req, res) => {
    return res.status(200).send({ error: "", mensaje: req.session.usuario });
};

async function GenerarHash(clave) {
    return await require('crypto').createHash('sha256').update(clave, 'utf8').digest('hex');
}

async function Compare(pass, hashed) {
    return hashed == pass ? true : false;
}